#ifndef _enclosure_h_
#define _enclosure_h_

#define MAX_SLOT 48	/* number of slots to make room for */

#define WPORT_TO_XPORT(port, delta) (((port) + (delta) + 16) % 16)
#define XPORT_TO_WPORT(port, delta) (((port) - (delta) + 16) % 16)
#define MAKE_PORT_DELTA(wport, xport) ((xport)-(wport))

extern int Nswitch;
extern struct enclosure *Switch;

/*
 * Structure describing one xbar port
 */
struct xbarport {
  /* where we are */
  struct enclosure *ep;
  int slotno;
  unsigned int portno;

  int xbarportno;	/* XbarPort number from monitoring card */

  /* current values */
  struct xbar_metrics {
    unsigned int invalidroutes;
    unsigned int goodcrcs;
    unsigned int badcrcs;
    unsigned int receivetimeoutcount;
    unsigned int transmittimeoutcount;
    unsigned int controlforxbarport;
  } vals;

   /* old values for computing deltas */
  struct xbar_metrics old_vals;

  /* static internal interconnect */
  struct fiberport *fp;
  struct xbarport *xp;
};

enum {
  PLUG_TYPE_UNKNOWN,
  PLUG_TYPE_NULL,
  PLUG_TYPE_HOST,
  PLUG_TYPE_PLUG
};

/*
 * Structure describing one fiber port
 */
struct fiberport {
  /* where we are */
  struct enclosure *ep;
  int slotno;
  unsigned int portno;

  /* current values */
  struct fiber_metrics {
    unsigned int signallost;
    unsigned int signallostcount;
    unsigned int controlforfiberport;
  } vals;

   /* old values for computing deltas */
  struct fiber_metrics old_vals;

  /* static internal interconnect */
  struct xbarport *xp;	/* wirelist xbar port we connect to internally */

  /* Variables for connecting this up with a map file */
  int plug_type;
  void *plug_ptr;
};


/*
 * Descriptor for each slot
 */
struct slotdesc {
  char serialno[64];	/* serial number */
  char model[64];	/* card model */
  char type[64];	/* type - should be a synonym for type */
  int num_xp;		/* number of xbar ports */
  int num_fiber;	/* number of fiber ports */
  char *fiber_port_string;  /* string to look for in HTML output */

  int port_label_offset; /* what to add to 0-based port to report */

  struct enclosure *ep;	/* enclosure for this slot */
  int slotno;

  /* ports associated with this line card */
  struct xbarport *xp;
  struct fiberport *fp;

  /* Variables for connecting this up with a map file */
  struct xbar *xbar;	/* structure for this xbar in the map file */
  int port_delta;	/* add this to wiring port index to get xbar port index */
};

/*
 * structure defining an entire enclosure.  This is large enough
 * to accomodate the largest enclosure we make.
 */
struct enclosure {
  char name[256];		/* IP name of the switch */
  int pid;			/* PID used in parallel querying */
  int unmapped_slots;		/* number of slots remaining to be mapped */
  int data_valid;		/* means the data in the struct is valid */

  int num_ext_slots;		/* number of pluggable slots */
  int num_bp_slots;		/* number of backplane slots */

  /* an entry for each slot */
  struct slotdesc *slot[MAX_SLOT];
};

#endif /* _enclosure_h_ */
